<?php
$arr = explode('_', $param);
if(count($arr) < 2) {
    $start = date('Y-01-01'); $end = date('Y-m-d');
    $start1 = date('01/01/Y'); $end1 = date('d/m/Y');
} else {
    $start = $arr[1]; $end = $arr[2];
    $start1 = date('d/m/Y', strtotime($arr[1])); $end1 = date('d/m/Y', strtotime($arr[2]));
}

$dist_id = reset($arr);

$dist = get_row_data('tbl_distributors', 'distributor_id', $dist_id);

$data = array('page' => 2, 'title' => $dist['distributor_name'].' Report: '.$dist['distributor_accountName']);
$this->load->view('layout/header', $data);

$csfa = $this->db->query("SELECT order_id, order_date, order_value, order_status, visit_userId, SUM(od_skuQty) AS volume FROM tbl_orders JOIN tbl_orderdetails ON od_orderid = order_id JOIN tbl_visits ON visit_id = order_visitId WHERE order_from = 'CSFA' AND visit_outlet_id = $dist_id AND STR_TO_DATE(order_date,'%Y-%m-%d') BETWEEN '$start' AND '$end'")->result_array();
  
$sap = $this->db->query("SELECT order_id, order_value, order_date, order_status, salesEmpNo, order_sapId FROM tbl_orders JOIN tbl_distributors ON distributor_accountName = order_clientAcct WHERE order_from = 'SAP' AND STR_TO_DATE(order_date,'%d/%m/%Y') BETWEEN '$start' AND '$end' AND order_clientAcct = '".$dist['distributor_accountName']."'")->result_array();
  
function get_sap_volume($id) {
  $conn = mssql_connect('192.168.21.95', 'so', 'Csfa@14');
    //Check only for those that have had the status updated by SAP i.e. sap order id != null
  $sql = "select OrderDetailsID,OrderDetails_SKUID, OrderDetails_Qty from OrderDetailsView where OrderDetailsID = $id";
  $query = mssql_query($sql);
  if($query === false)
        {
                return "Error in query prep or exec.\n";
                //die( print_r(mssql_errors(),true));
        }
  $vol = 0;
  while($row = mssql_fetch_array($query)) {
     $vol += $row['OrderDetails_Qty']*get_that_data('tbl_items', 'item_code', $row['OrderDetails_SKUID'], 'item_skusize');
  }
  return $vol;
}

$total = $vol = $val= 0;
?>

    
      <!-- page content -->
      <div class="right_col" role="main">
        <div class="">
          <div class="page-title">
            <div class="title_left">
              <h3>
                    <?php echo $data['title']?>
                    <small><?php echo "From: $start to: $end"?></small>
                </h3>
            </div>

            <div class="title_right">
              <div class="col-md-5 col-sm-5 col-xs-12 form-group pull-right top_search">
                <!--<button class="btn btn-success pull-right" data-toggle="modal" data-target="#myModal"><i class="fa fa-plus"></i> Add New</button>-->
              </div>
            </div>
          </div>
          <div class="clearfix"></div>

          <div class="row">

            <div class="col-md-12 col-sm-12 col-xs-12">
              <div class="x_panel">
                <div class="x_title">
                  <h2><?php echo $data['title'];?> </h2>
                  
                  <ul class="nav navbar-right panel_toolbox">
                    <div id="reportrange" class="pull-right" style="background: #fff; cursor: pointer; padding: 5px 10px; border: 1px solid #ccc">
                    <i class="glyphicon glyphicon-calendar fa fa-calendar"></i>
                    <span><?php echo "$start - $end";?></span> <b class="caret"></b>
                  </div>
                  </ul>
                  <div class="clearfix"></div>
                </div>
                <div class="x_content">
                    
                    <div>
                    
                      <!-- Nav tabs -->
                      <ul class="nav nav-tabs" role="tablist">
                        <li role="presentation" class="active"><a href="#home" aria-controls="home" role="tab" data-toggle="tab">CSFA Orders</a></li>
                        <li role="presentation"><a href="#profile" aria-controls="profile" role="tab" data-toggle="tab">SAP Orders</a></li>
                      </ul>
                    
                      <!-- Tab panes -->
                      <div class="tab-content">
                        <div role="tabpanel" class="tab-pane active" id="home">
                            <div class="clearfix"><br/></div>
                            <table id="datatable-buttons" class="table table-striped table-bordered datatable-buttons">
                                <thead>
                                  <tr>
                                    <th>Date</th>
                                    <th>Order ID</th>
                                    <th>Sales Rep</th>
                                    <th>Volume</th>
                                    <th>Value</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                  </tr>
                                </thead>
            
            
                                <tbody>
                                  <?php foreach($csfa as $c) { $total++; $val+=$c['order_value']; $vol+=$c['volume']; ?>
                                  <tr>
                                    <td><?php echo date('d/m/Y', strtotime($c['order_date']));?></td>
                                    <td><?php echo $c['order_id'];?></td>
                                    <td><?php echo get_that_data('tbl_users', 'user_id', $c['visit_userId'], 'user_fullname');?></td>
                                    <td><?php echo $c['volume'];?></td>
                                    <td><?php echo "KES. ".number_format($c['order_value']);?></td>
                                    <td>
                                        <?php echo $c['order_status'] == '1' ? '<span class="label label-success">CLOSED</span>' : '<span class="label label-default">Pending</span>';
                                        ?>
                                    </td>
                                    <td><a href="<?php echo site_url('welcome/view/csfa_order/'.$c['order_id'])?>"><i class="fa fa-eye"></i> Details</a></td>
                                  </tr>
                                  <?php } ?>
                                </tbody>
                              </table>
                  
                        </div>
                        
                        <div role="tabpanel" class="tab-pane active" id="profile">
                            <div class="clearfix"><br/></div>
                            <table id="datatable-buttons" class="table table-striped table-bordered datatable-buttons">
                                <thead>
                                  <tr>
                                    <th>Date</th>
                                    <th>Order ID</th>
                                    <th>Sales Rep</th>
                                    <th>Volume</th>
                                    <th>Value</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                  </tr>
                                </thead>
            
            
                                <tbody>
                                  <?php foreach($sap as $c) { $sap_vol = get_sap_volume($c['order_sapId']); $total++; $val+=$c['order_value']; $vol+=$sap_vol; ?>
                                  <tr>
                                    <td><?php echo $c['order_date']?></td>
                                    <td><?php echo $c['order_sapId']?></td>
                                    <td><?php echo get_that_data('tbl_users', 'user_sapId', $c['salesEmpNo'], 'user_fullname')?></td>
                                    <td><?php echo $sap_vol?></td>
                                    <td><?php echo "KES. ".number_format($c['order_value'])?></td>
                                    <td>
                                        <?php echo $c['order_status'] == '1' ? '<span class="label label-success">CLOSED</span>' : '<span class="label label-default">Pending</span>';
                                        ?>
                                    </td>
                                    <td><a href="<?php echo site_url('welcome/view/sap_order/'.$c['order_sapId'])?>"><i class="fa fa-eye"></i> Details</a></td>
                                  </tr>
                                  <?php } ?>
                                </tbody>
                              </table>
                  
                        </div>
                        
                      </div>
                    
                    </div>
                    
                    <br />
                    <div class="row"> <hr />
                        <h3 class="text-center">Quick Summary</h3>
                        <div class="col-md-4">
                            <p><strong>Total Orders: </strong> <?php echo $total?></p>
                        </div>
                        <div class="col-md-4">
                            <p><strong>Total Volume: </strong> <?php echo number_format($vol)?></p>
                        </div>
                        <div class="col-md-4">
                            <p><strong>Total Value: </strong> <?php echo "KES. ".number_format($val,2)?></p>
                        </div>
                    </div>
                  
                </div>
              </div>
            </div>
                </div>
              </div>
<!-- Modal -->
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="myModalLabel">New User</h4>
      </div>
      <form method="post" action="<?php echo site_url('system/act/meters_model/create_connection')?>" id="ajax-form" class="form-horizontal">
        <div class="modal-body">
            <div class="form-group">
                <label class="col-md-3">Connection Number</label>
                <div class="col-md-9">
                    <input type="number" name="number" class="form-control" placeholder="" required=""/>
                </div>
            </div>
            <div class="form-group">
                <label class="col-md-3">Consumer Name</label>
                <div class="col-md-9">
                    <select name="consumer" class="form-control">
                        <option>---Select One--</option>
                    </select>
                </div>
            </div>
            <div class="form-group">
                <label class="col-md-3">Meter Number</label>
                <div class="col-md-9">
                    <select name="meter" class="form-control">
                        <option>---Select One--</option>
                    </select>
                </div>
            </div>
            <div class="form-group">
                <label class="col-md-3">Route</label>
                <div class="col-md-9">
                    <select name="route" class="form-control">
                        <option>---Select Route--</option>
                    </select>
                </div>
            </div>
            <div class="form-group">
                <label class="col-md-3">Connection Type</label>
                <div class="col-md-9">
                    <select name="type" class="form-control">
                        <option>---Select One--</option>
                    </select>
                </div>
            </div>
            <div class="form-group">
                <label class="col-md-3">Location</label>
                <div class="col-md-9">
                    <input type="text" name="location" class="form-control" required=""/>
                </div>
            </div>
            
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            <button type="submit" class="btn btn-success"><i class="fa fa-save"></i> Save</button>
          </div>
      </form>
    </div>
  </div>
</div>                
<?php $this->load->view('layout/footer') ; ?>

<!-- Jqury Form -->
<script src="<?php echo base_url('assets/js/jquery.form.min.js')?>"></script>
<script src="<?php echo base_url('assets/js/jquery.bootstrap-growl.min.js')?>"></script>
<script>
    var frm = $("#ajax-form");
    var options = {
        beforeSend: function()
        {
            /* set the message */
            frm.find('input, select, textarea, button').attr('disabled',  true);
            //btn.attr('disabled', true).html('Please wait..')

        },
        success: function(data)
        {
            var resp = JSON.parse(data);
            var status = resp.status;
            var msg = resp.msg;

            if (status == 1) {
                /* set the message */
                $.bootstrapGrowl(msg);
                frm.find('input, select, textarea, button').attr('disabled', false);
                location.reload();

            } else {
                /* set the message */
                $.bootstrapGrowl('<<strong>Error!</strong> '+msg, { type: 'danger', delay: 4000});
                frm.find('select, input, textarea').attr('disabled', false);
            }

        },
        error: function()
        {
            /* set the message */
            var alert = 'Serious error. Contact Support.';

            /* show the alert */
            btn.html(alert);
            location.reload();
        }

    };

    $("#ajax-form").ajaxForm(options);
</script>
<!-- Datatables-->
        <script src="<?php echo base_url('assets/js/datatables/jquery.dataTables.min.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/dataTables.bootstrap.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/dataTables.buttons.min.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/buttons.bootstrap.min.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/jszip.min.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/pdfmake.min.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/vfs_fonts.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/buttons.html5.min.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/buttons.print.min.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/dataTables.fixedHeader.min.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/dataTables.keyTable.min.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/dataTables.responsive.min.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/responsive.bootstrap.min.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/dataTables.scroller.min.js')?>"></script>


        <!-- pace -->
        <script src="<?php echo base_url('assets/js/pace/pace.min.js')?>"></script>
        <script>
          $(document).ready(function() {
            var table = $('#example').DataTable( {
              ajax: "<?php echo site_url('data/dealer_report/')?>"
            } );
          } );
        </script>
        <script>
          var handleDataTableButtons = function() {
              "use strict";
              0 !== $(".datatable-buttons").length && $(".datatable-buttons").DataTable({
                dom: "Bfrtip",
                buttons: [{
                  extend: "copy",
                  className: "btn-sm"
                }, {
                  extend: "csv",
                  className: "btn-sm"
                }, {
                  extend: "excel",
                  className: "btn-sm"
                }, {
                  extend: "pdf",
                  className: "btn-sm"
                }, {
                  extend: "print",
                  className: "btn-sm"
                }],
                responsive: !0
              })
            },
            TableManageButtons = function() {
              "use strict";
              return {
                init: function() {
                  handleDataTableButtons()
                }
              }
            }();
        </script>
        <script type="text/javascript">
          TableManageButtons.init();
        </script>
    <script type="text/javascript" src="<?php echo base_url('assets/js/datepicker/daterangepicker.js')?>"></script>      
        <!-- datepicker -->
  <script type="text/javascript">
    $(document).ready(function() {

      var cb = function(start, end, label) {
        console.log(start.toISOString(), end.toISOString(), label);
        location.href = '<?php echo site_url('welcome/reports/dealer_details/'.$dist_id)?>_'+start.format('YYYY-MM-DD')+'_'+end.format('YYYY-MM-DD');
      }

      var optionSet1 = {
        startDate: moment().subtract(1, 'months'),
        endDate: moment(),
        showDropdowns: true,
        showWeekNumbers: true,
        timePicker: false,
        timePickerIncrement: 1,
        timePicker12Hour: true,
        ranges: {
          'Today': [moment(), moment()],
          'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
          'Last 7 Days': [moment().subtract(6, 'days'), moment()],
          'Last 30 Days': [moment().subtract(29, 'days'), moment()],
          'This Month': [moment().startOf('month'), moment().endOf('month')],
          'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        },
        opens: 'left',
        buttonClasses: ['btn btn-default'],
        applyClass: 'btn-small btn-primary',
        cancelClass: 'btn-small',
        format: 'MM/DD/YYYY',
        separator: ' to ',
        locale: {
          applyLabel: 'Submit',
          cancelLabel: 'Clear',
          fromLabel: 'From',
          toLabel: 'To',
          customRangeLabel: 'Custom',
          daysOfWeek: ['Su', 'Mo', 'Tu', 'We', 'Th', 'Fr', 'Sa'],
          monthNames: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'],
          firstDay: 1
        }
      };
      $('#reportrange span').html(moment().subtract(29, 'days').format('MMMM D, YYYY') + ' - ' + moment().format('MMMM D, YYYY'));
      $('#reportrange').daterangepicker(optionSet1, cb);
      $('#reportrange').on('show.daterangepicker', function() {
        console.log("show event fired");
      });
      $('#reportrange').on('hide.daterangepicker', function() {
        console.log("hide event fired");
      });
      $('#reportrange').on('apply.daterangepicker', function(ev, picker) {
        console.log("apply event fired, start/end dates are " + picker.startDate.format('MMMM D, YYYY') + " to " + picker.endDate.format('MMMM D, YYYY'));
      });
      $('#reportrange').on('cancel.daterangepicker', function(ev, picker) {
        console.log("cancel event fired");
      });
      $('#options1').click(function() {
        $('#reportrange').data('daterangepicker').setOptions(optionSet1, cb);
      });
      $('#options2').click(function() {
        $('#reportrange').data('daterangepicker').setOptions(optionSet2, cb);
      });
      $('#destroy').click(function() {
        $('#reportrange').data('daterangepicker').remove();
      });
    });
  </script>
        
</body>

</html>
