<?php
$data = array('page' => 2, 'title' => 'Dealerwise Reports');
$this->load->view('layout/header', $data);
if(empty($param)) {
    $start = date('Y-01-01'); $end = date('Y-m-d');
} else {
    $arr = explode('_', $param);
    $start = reset($arr); $end = end($arr);
}
  $user = get_row_data('tbl_users', 'user_id', $this->session->userdata('user_id'));
if($user['user_usertypeid'] == 3) {
    $dealers = get_data('tbl_distributors', "WHERE salesEmpNo = ".$user['user_sapId']);
} else {
    $dealers = get_data('tbl_distributors');
}
?>

    
      <!-- page content -->
      <div class="right_col" role="main">
        <div class="">
          <div class="page-title">
            <div class="title_left">
              <h3>
                    <?php echo $data['title']?>
                </h3>
            </div>

            <div class="title_right">
              <div class="col-md-5 col-sm-5 col-xs-12 form-group pull-right top_search">
                <!--<button class="btn btn-success pull-right" data-toggle="modal" data-target="#myModal"><i class="fa fa-plus"></i> Add New</button>-->
              </div>
            </div>
          </div>
          <div class="clearfix"></div>

          <div class="row">

            <div class="col-md-12 col-sm-12 col-xs-12">
              <div class="x_panel">
                <div class="x_title">
                  <h2><?php echo $data['title'];?> <small><?php echo $start.' to '.$end;?></small></h2>
                  <ul class="nav navbar-right panel_toolbox">
                    <div id="reportrange" class="pull-right" style="background: #fff; cursor: pointer; padding: 5px 10px; border: 1px solid #ccc">
                    <i class="glyphicon glyphicon-calendar fa fa-calendar"></i>
                    <span>December 30, 2014 - January 28, 2015</span> <b class="caret"></b>
                  </div>
                  </ul>
                  <div class="clearfix"></div>
                </div>
                <div class="x_content">
                  
                  <table id="datatable-buttons" class="table table-striped table-bordered">
                    <thead>
                      <tr>
                        <th>Name</th>
                        <th>Account</th>
                        <th>Sales Rep</th>
                        <th>No of Orders</th>
                        <th>Total Volume</th>
                        <th>Total Value</th>
                        <th>Status</th>
                        <th>Action</th>
                      </tr>
                    </thead>


                    <tbody>
                      <?php foreach($dealers as $c) { 
                        $csfa = get_dist_csfa($c['distributor_id'], $start, $end); 
                        $sap = get_dist_sap($c['distributor_accountName'], $start, $end); 
                        $csfa_total = isset($csfa['total']) ? $csfa['total'] : 0;
                        $sap_total = isset($sap['total']) ? $sap['total'] : 0;
                        $csfa_vol = isset($csfa['volume']) ? $csfa['volume'] : 0;
                        $sap_vol = isset($sap['volume']) ? $sap['volume'] : 0;
                        $csfa_val = isset($csfa['value']) ? $csfa['value'] : 0;
                        $sap_val = isset($sap['value']) ? $sap['value'] : 0;
                        ?>
                      <tr>
                        <td><a href="<?php echo site_url('welcome/reports/dealer_details/'.$c['distributor_id'])?>"><?php echo $c['distributor_name']?></a></td>
                        <td><?php echo $c['distributor_accountName']?></td>
                        <td><?php echo get_that_data('tbl_users', 'user_sapId', $c['salesEmpNo'], 'user_fullname')?></td>
                        <td><?php echo $csfa_total+$sap_total?></td>
                        <td><?php echo number_format($csfa_vol+$sap_vol)?></td>
                        <td><?php echo "KES. ".number_format($csfa_val+$sap_val,2)?></td>
                        <td>
                            <?php echo $c['distributor_active'] == 'Y' ? '<span class="label label-success">Active</span>' : '<span class="label label-default">Inactive</span>';
                            ?>
                        </td>
                        <td><a href="<?php echo site_url('welcome/reports/dealer_details/'.$c['distributor_id'])?>"><i class="fa fa-eye"></i> View</a></td>
                      </tr>
                      <?php } ?>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
                </div>
              </div>
<!-- Modal -->
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="myModalLabel">New User</h4>
      </div>
      <form method="post" action="<?php echo site_url('system/act/meters_model/create_connection')?>" id="ajax-form" class="form-horizontal">
        <div class="modal-body">
            <div class="form-group">
                <label class="col-md-3">Connection Number</label>
                <div class="col-md-9">
                    <input type="number" name="number" class="form-control" placeholder="" required=""/>
                </div>
            </div>
            <div class="form-group">
                <label class="col-md-3">Consumer Name</label>
                <div class="col-md-9">
                    <select name="consumer" class="form-control">
                        <option>---Select One--</option>
                    </select>
                </div>
            </div>
            <div class="form-group">
                <label class="col-md-3">Meter Number</label>
                <div class="col-md-9">
                    <select name="meter" class="form-control">
                        <option>---Select One--</option>
                    </select>
                </div>
            </div>
            <div class="form-group">
                <label class="col-md-3">Route</label>
                <div class="col-md-9">
                    <select name="route" class="form-control">
                        <option>---Select Route--</option>
                    </select>
                </div>
            </div>
            <div class="form-group">
                <label class="col-md-3">Connection Type</label>
                <div class="col-md-9">
                    <select name="type" class="form-control">
                        <option>---Select One--</option>
                    </select>
                </div>
            </div>
            <div class="form-group">
                <label class="col-md-3">Location</label>
                <div class="col-md-9">
                    <input type="text" name="location" class="form-control" required=""/>
                </div>
            </div>
            
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            <button type="submit" class="btn btn-success"><i class="fa fa-save"></i> Save</button>
          </div>
      </form>
    </div>
  </div>
</div>                
<?php $this->load->view('layout/footer') ; ?>

<!-- Jqury Form -->
<script src="<?php echo base_url('assets/js/jquery.form.min.js')?>"></script>
<script src="<?php echo base_url('assets/js/jquery.bootstrap-growl.min.js')?>"></script>
<script>
    var frm = $("#ajax-form");
    var options = {
        beforeSend: function()
        {
            /* set the message */
            frm.find('input, select, textarea, button').attr('disabled',  true);
            //btn.attr('disabled', true).html('Please wait..')

        },
        success: function(data)
        {
            var resp = JSON.parse(data);
            var status = resp.status;
            var msg = resp.msg;

            if (status == 1) {
                /* set the message */
                $.bootstrapGrowl(msg);
                frm.find('input, select, textarea, button').attr('disabled', false);
                location.reload();

            } else {
                /* set the message */
                $.bootstrapGrowl('<<strong>Error!</strong> '+msg, { type: 'danger', delay: 4000});
                frm.find('select, input, textarea').attr('disabled', false);
            }

        },
        error: function()
        {
            /* set the message */
            var alert = 'Serious error. Contact Support.';

            /* show the alert */
            btn.html(alert);
            location.reload();
        }

    };

    $("#ajax-form").ajaxForm(options);
</script>
<!-- Datatables-->
        <script src="<?php echo base_url('assets/js/datatables/jquery.dataTables.min.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/dataTables.bootstrap.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/dataTables.buttons.min.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/buttons.bootstrap.min.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/jszip.min.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/pdfmake.min.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/vfs_fonts.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/buttons.html5.min.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/buttons.print.min.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/dataTables.fixedHeader.min.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/dataTables.keyTable.min.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/dataTables.responsive.min.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/responsive.bootstrap.min.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/dataTables.scroller.min.js')?>"></script>


        <!-- pace -->
        <script src="<?php echo base_url('assets/js/pace/pace.min.js')?>"></script>
        <script>
          $(document).ready(function() {
            var table = $('#example').DataTable( {
              ajax: "<?php echo site_url('data/dealer_report/')?>"
            } );
          } );
        </script>
        <script>
          var handleDataTableButtons = function() {
              "use strict";
              0 !== $("#datatable-buttons").length && $("#datatable-buttons").DataTable({
                dom: "Bfrtip",
                buttons: [{
                  extend: "copy",
                  className: "btn-sm"
                }, {
                  extend: "csv",
                  className: "btn-sm"
                }, {
                  extend: "excel",
                  className: "btn-sm"
                }, {
                  extend: "pdf",
                  className: "btn-sm"
                }, {
                  extend: "print",
                  className: "btn-sm"
                }],
                responsive: !0
              })
            },
            TableManageButtons = function() {
              "use strict";
              return {
                init: function() {
                  handleDataTableButtons()
                }
              }
            }();
        </script>
        <script type="text/javascript">
          TableManageButtons.init();
        </script>
    <script type="text/javascript" src="<?php echo base_url('assets/js/datepicker/daterangepicker.js')?>"></script>      
        <!-- datepicker -->
  <script type="text/javascript">
    $(document).ready(function() {

      var cb = function(start, end, label) {
        console.log(start.toISOString(), end.toISOString(), label);
        location.href = '<?php echo site_url('welcome/reports/dealer')?>/'+start.format('YYYY-MM-DD')+'_'+end.format('YYYY-MM-DD');
      }

      var optionSet1 = {
        startDate: moment().subtract(1, 'months'),
        endDate: moment(),
        showDropdowns: true,
        showWeekNumbers: true,
        timePicker: false,
        timePickerIncrement: 1,
        timePicker12Hour: true,
        ranges: {
          'Today': [moment(), moment()],
          'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
          'Last 7 Days': [moment().subtract(6, 'days'), moment()],
          'Last 30 Days': [moment().subtract(29, 'days'), moment()],
          'This Month': [moment().startOf('month'), moment().endOf('month')],
          'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        },
        opens: 'left',
        buttonClasses: ['btn btn-default'],
        applyClass: 'btn-small btn-primary',
        cancelClass: 'btn-small',
        format: 'MM/DD/YYYY',
        separator: ' to ',
        locale: {
          applyLabel: 'Submit',
          cancelLabel: 'Clear',
          fromLabel: 'From',
          toLabel: 'To',
          customRangeLabel: 'Custom',
          daysOfWeek: ['Su', 'Mo', 'Tu', 'We', 'Th', 'Fr', 'Sa'],
          monthNames: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'],
          firstDay: 1
        }
      };
      $('#reportrange span').html(moment().subtract(29, 'days').format('MMMM D, YYYY') + ' - ' + moment().format('MMMM D, YYYY'));
      $('#reportrange').daterangepicker(optionSet1, cb);
      $('#reportrange').on('show.daterangepicker', function() {
        console.log("show event fired");
      });
      $('#reportrange').on('hide.daterangepicker', function() {
        console.log("hide event fired");
      });
      $('#reportrange').on('apply.daterangepicker', function(ev, picker) {
        console.log("apply event fired, start/end dates are " + picker.startDate.format('MMMM D, YYYY') + " to " + picker.endDate.format('MMMM D, YYYY'));
      });
      $('#reportrange').on('cancel.daterangepicker', function(ev, picker) {
        console.log("cancel event fired");
      });
      $('#options1').click(function() {
        $('#reportrange').data('daterangepicker').setOptions(optionSet1, cb);
      });
      $('#options2').click(function() {
        $('#reportrange').data('daterangepicker').setOptions(optionSet2, cb);
      });
      $('#destroy').click(function() {
        $('#reportrange').data('daterangepicker').remove();
      });
    });
  </script>
        
</body>

</html>
