<?php
$data = array('page' => 2, 'title' => 'Dealers');
$this->load->view('layout/header', $data);
$user = get_row_data('tbl_users', 'user_id', $this->session->userdata('user_id'));
if($user['user_usertypeid'] == 3) {
    $dealers = get_data('tbl_distributors', "WHERE salesEmpNo = ".$user['user_sapId']);
} elseif($user['user_usertypeid'] == 2) {
    $dealers = get_data('tbl_distributors', "WHERE distributor_blockId = ".$user['user_fieldId']);
} else {
    $dealers = get_data('tbl_distributors');
}
?>

    
      <!-- page content -->
      <div class="right_col" role="main">
        <div class="">
          <div class="page-title">
            <div class="title_left">
              <h3>
                    <?php echo $data['title']?>
                    
                </h3>
            </div>

            <div class="title_right">
              <div class="col-md-5 col-sm-5 col-xs-12 form-group pull-right top_search">
                <a class="btn btn-success pull-right" href="<?php echo site_url('welcome/reports/dealers')?>"><i class="fa fa-plus"></i> View Dealer Reports</a>
              </div>
            </div>
          </div>
          <div class="clearfix"></div>

          <div class="row">

            <div class="col-md-12 col-sm-12 col-xs-12">
              <div class="x_panel">
                <div class="x_title">
                  <h2><?php echo $data['title']?> <small>List</small></h2>
                  <ul class="nav navbar-right panel_toolbox">
                    <li><a href="#"><i class="fa fa-chevron-up"></i></a>
                    </li>
                    <li class="dropdown">
                      <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false"><i class="fa fa-wrench"></i></a>
                      <ul class="dropdown-menu" role="menu">
                        <li><a href="#">Settings 1</a>
                        </li>
                        <li><a href="#">Settings 2</a>
                        </li>
                      </ul>
                    </li>
                    <li><a href="#"><i class="fa fa-close"></i></a>
                    </li>
                  </ul>
                  <div class="clearfix"></div>
                </div>
                <div class="x_content">
                  
                  <table id="datatable-buttons" class="table table-striped table-bordered">
                    <thead>
                      <tr>
                        <th>Name</th>
                        <th>Account</th>
                        <th>Sales Officer</th>
                        <th>Block</th>
                        <th>Address</th>
                        <th>Last Visit</th>
                        <th>Status</th>
                        <th>Action</th>
                      </tr>
                    </thead>


                    <tbody>
                      <?php foreach($dealers as $c) { ?>
                      <tr>
                        <td><?php echo $c['distributor_name']?></td>
                        <td><?php echo $c['distributor_accountName']?></td>
                        <td><?php echo get_that_data('tbl_users', 'user_sapId', $c['salesEmpNo'], 'user_fullname')?></td>
                        <td><?php echo get_that_data('tbl_blocks', 'block_id', $c['distributor_blockid'], 'block_name')?></td>
                        <td><?php echo $c['distributor_address']?></td>
                        <td><?php echo get_last_visit_date($c['distributor_id'])?></td>
                        <td>
                            <?php echo $c['distributor_active'] == 'Y' ? '<span class="label label-success">Active</span>' : '<span class="label label-default">Inactive</span>';
                            ?>
                        </td>
                        <td>
                            <a href="<?php echo site_url('welcome/reports/dealer_details/'.$c['distributor_id'])?>"><i class="fa fa-eye"> View</i></a>
                        </td>
                      </tr>
                      <?php } ?>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
                </div>
              </div>
<!-- Modal -->
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="myModalLabel">New User</h4>
      </div>
      <form method="post" action="<?php echo site_url('system/act/meters_model/create_connection')?>" id="ajax-form" class="form-horizontal">
        <div class="modal-body">
            <div class="form-group">
                <label class="col-md-3">Connection Number</label>
                <div class="col-md-9">
                    <input type="number" name="number" class="form-control" placeholder="" required=""/>
                </div>
            </div>
            <div class="form-group">
                <label class="col-md-3">Consumer Name</label>
                <div class="col-md-9">
                    <select name="consumer" class="form-control">
                        <option>---Select One--</option>
                    </select>
                </div>
            </div>
            <div class="form-group">
                <label class="col-md-3">Meter Number</label>
                <div class="col-md-9">
                    <select name="meter" class="form-control">
                        <option>---Select One--</option>
                    </select>
                </div>
            </div>
            <div class="form-group">
                <label class="col-md-3">Route</label>
                <div class="col-md-9">
                    <select name="route" class="form-control">
                        <option>---Select Route--</option>
                    </select>
                </div>
            </div>
            <div class="form-group">
                <label class="col-md-3">Connection Type</label>
                <div class="col-md-9">
                    <select name="type" class="form-control">
                        <option>---Select One--</option>
                    </select>
                </div>
            </div>
            <div class="form-group">
                <label class="col-md-3">Location</label>
                <div class="col-md-9">
                    <input type="text" name="location" class="form-control" required=""/>
                </div>
            </div>
            
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            <button type="submit" class="btn btn-success"><i class="fa fa-save"></i> Save</button>
          </div>
      </form>
    </div>
  </div>
</div>                
<?php $this->load->view('layout/footer') ; ?>

<!-- Jqury Form -->
<script src="<?php echo base_url('assets/js/jquery.form.min.js')?>"></script>
<script src="<?php echo base_url('assets/js/jquery.bootstrap-growl.min.js')?>"></script>
<script>
    var frm = $("#ajax-form");
    var options = {
        beforeSend: function()
        {
            /* set the message */
            frm.find('input, select, textarea, button').attr('disabled',  true);
            //btn.attr('disabled', true).html('Please wait..')

        },
        success: function(data)
        {
            var resp = JSON.parse(data);
            var status = resp.status;
            var msg = resp.msg;

            if (status == 1) {
                /* set the message */
                $.bootstrapGrowl(msg);
                frm.find('input, select, textarea, button').attr('disabled', false);
                location.reload();

            } else {
                /* set the message */
                $.bootstrapGrowl('<<strong>Error!</strong> '+msg, { type: 'danger', delay: 4000});
                frm.find('select, input, textarea').attr('disabled', false);
            }

        },
        error: function()
        {
            /* set the message */
            var alert = 'Serious error. Contact Support.';

            /* show the alert */
            btn.html(alert);
            location.reload();
        }

    };

    $("#ajax-form").ajaxForm(options);
</script>
<!-- Datatables-->
        <script src="<?php echo base_url('assets/js/datatables/jquery.dataTables.min.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/dataTables.bootstrap.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/dataTables.buttons.min.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/buttons.bootstrap.min.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/jszip.min.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/pdfmake.min.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/vfs_fonts.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/buttons.html5.min.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/buttons.print.min.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/dataTables.fixedHeader.min.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/dataTables.keyTable.min.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/dataTables.responsive.min.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/responsive.bootstrap.min.js')?>"></script>
        <script src="<?php echo base_url('assets/js/datatables/dataTables.scroller.min.js')?>"></script>


        <!-- pace -->
        <script src="<?php echo base_url('assets/js/pace/pace.min.js')?>"></script>
        <script>
          var handleDataTableButtons = function() {
              "use strict";
              0 !== $("#datatable-buttons").length && $("#datatable-buttons").DataTable({
                dom: "Blfrtip",
                buttons: [{
                  extend: "copy",
                  className: "btn-sm"
                }, {
                  extend: "csv",
                  className: "btn-sm"
                }, {
                  extend: "excel",
                  className: "btn-sm"
                }, {
                  extend: "pdf",
                  className: "btn-sm"
                }, {
                  extend: "print",
                  className: "btn-sm"
                }],
                responsive: !0
              })
            },
            TableManageButtons = function() {
              "use strict";
              return {
                init: function() {
                  handleDataTableButtons()
                }
              }
            }();
        </script>
        <script type="text/javascript">
          TableManageButtons.init();
        </script>
</body>

</html>
