<?php
$user = get_row_data('tbl_users', 'user_id', $this->session->userdata('user_id'));
if($user['user_usertypeid'] == 3) {
    $dealers = get_data('tbl_distributors', "WHERE salesEmpNo = ".$user['user_sapId']);
} else {
    $dealers = get_data('tbl_distributors');
}
?>
<!DOCTYPE html>
<html>
  <head>
    <meta name="viewport" content="initial-scale=1.0, user-scalable=no">
    <meta charset="utf-8">
    <title>Dealer Mapping</title>
    <style>
      /* Always set the map height explicitly to define the size of the div
       * element that contains the map. */
      #map {
        height: 100%;
        z-index: 1000;
      }
      /* Optional: Makes the sample page fill the window. */
      html, body {
        height: 100%;
        margin: 0;
        padding: 0;
      }
      #title {
        padding-top: 5em;
        width: 90%;
        margin-left: 2em;
        z-index: 10001;
      }
    </style>
  </head>
  <body>
    <div id="map"></div>
    <div id="title">
        <h1>CSFA Dealer Map</h1>
        <a href="<?php echo site_url()?>">Back</a>
    </div>
    <div id="results-container">
      <h3>Results</h3>
      <select id="results-list">
      </select><!-- #results-list -->
    </div><!-- #results-container -->
    <script>

      // This at the center of Nairobi.
      // When the user clicks the marker, an info window opens.
      // The maximum width of the info window is set to 200 pixels.

      function initMap() {
        var uluru = {lat: -1.395988100, lng: 36.756921000};
        var map = new google.maps.Map(document.getElementById('map'), {
          zoom: 6,
          center: uluru
        });

        <?php
                    foreach($dealers as $d) { ?>
            
            var contentString = '<?php
                    $locs = '<div id="content"><div id="siteNotice>';
                        $locs .= '<h1 id="firstHeading" class="firstHeading"><strong>'.str_replace("'", "", $d['distributor_name']).'</strong></h1></div>';
                        $locs .= '<div id="bodyContent">';
                        $locs .= '<p><b>Acct #: '.$d['distributor_accountName'].'</b><br/>Sales Person: <b>'.get_that_data('tbl_users', 'user_sapId', $d['salesEmpNo'], 'user_fullname').'</b><br/>Block: <strong>'.get_that_data('tbl_blocks', 'block_id', $d['distributor_blockid'], 'block_name').'</strong></p>';
                        
                        if(!get_last_visit_date($d['distributor_id'])) {
                            $locs .= '<p>(<strong>Not Visited Yet</strong>).</p>';
                        } else {
                            $locs .= '<p>(Last visited <strong>'.date('F j Y g:i a', strtotime(get_last_visit_date($d['distributor_id']))).')</strong>.</p>';
                        }
                        $locs .= '</div>';
                        
                    $locs .= '</div>';
                    echo $locs;
                ?>';
            
             $( '#results-list' ).append(
                      $( '<option />' )
                       .attr( 'id', 'map-marker-' + <?php echo $d['distributor_id']?>)
                       .attr( 'class', 'depot-result' )
                       .html('<?php echo str_replace("'", "", $d['distributor_name'])?>')
            );

            var marker = new google.maps.Marker({
              position: {lat: <?php echo $d['distributor_lat']?>, lng: <?php echo $d['distributor_long']?>},
              map: map,
              title: '<?php echo str_replace("'", "", $d['distributor_name'])?>',
              <?php if(get_last_visit_date($d['distributor_id'])) { ?>
                icon : 'http://maps.google.com/mapfiles/ms/icons/green-dot.png'
              <?php } ?>
            });
            attachSecretMessage(marker, contentString);

        <?php } ?>
      }
      
      // Attaches an info window to a marker with the provided message. When the
      // marker is clicked, the info window will open with the secret message.
      function attachSecretMessage(marker, secretMessage) {
        var infowindow = new google.maps.InfoWindow({
          content: secretMessage
        });

        marker.addListener('click', function() {
          infowindow.open(marker.get('map'), marker);
        });
      }

    </script>
    <script async defer
    src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDoGxBzTaKMdMSYhKgzGhzl2jYf6vPQIW0&callback=initMap">
    </script>
    <script src="<?php echo base_url('assets/js/jquery.min.js')?>"></script>
  </body>
</html>
