<?php
$data = array('title' => 'Welcome', 'page' => 1);
$this->load->view('layout/header', $data);
?>
 <div id="echart_pie" style="height:350px;"></div>
<?php $this->load->view('layout/footer'); ?>

<!-- echart -->
  <script src="<?php echo base_url('assets/js/echart/echarts-all.js')?>"></script>
  <script src="<?php echo base_url('assets/js/echart/green.js')?>"></script>
  <script>
    $.get('<?php echo site_url('data/get_block_chart_data')?>', function(res) {
      var d = JSON.parse(res);
      var dataset = JSON.stringify(d.datasets) ;
      console.log(dataset);
    var myChart = echarts.init(document.getElementById('echart_pie'), theme);
    myChart.setOption({
      tooltip: {
        trigger: 'item',
        formatter: "{a} <br/>{b} : {c} ({d}%)"
      },
      legend: {
        //orient: 'vertical',
        //x: 'left',
        x: 'center',
        y: 'bottom',
        data: d.zones
      },
      toolbox: {
        show: true,
        feature: {
          magicType: {
            show: true,
            type: ['pie', 'funnel'],
            option: {
              funnel: {
                x: '25%',
                width: '50%',
                funnelAlign: 'left',
                max: 1548
              }
            }
          },
          restore: {
            show: true
          },
          saveAsImage: {
            show: true
          }
        }
      },
      calculable: true,
      series: [{
        name: '访问来源',
        type: 'pie',
        radius: '55%',
        center: ['50%', '48%'], //left,top
        data: dataset
      }]
    });  
    });
 </script>
