<?php
//ini_set('display_errors', 1);
$data = array('title' => 'Welcome', 'page' => 1);
$this->load->view('layout/header', $data);


$user = get_row_data('tbl_users', 'user_id', $this->session->userdata('user_id'));
$start = date('Y-m-01'); $end = date('Y-m-d');
$orders = $this->db->query("SELECT COUNT(order_id) AS o_total FROM tbl_orders WHERE order_cancelled = 0 AND STR_TO_DATE(order_date,'%d/%m/%Y') BETWEEN '$start' AND '$end'")->row_array();
if($user['user_usertypeid'] == 3) {
    $csfa = $this->db->query("SELECT SUM(order_value) AS value, SUM(od_skuQty) AS volume, COUNT(order_id) AS total FROM tbl_orderdetails JOIN tbl_orders ON od_orderid = order_id JOIN tbl_visits ON visit_id = order_visitId WHERE order_cancelled = 0 AND STR_TO_DATE(order_date,'%Y-%m-%d') BETWEEN '$start' AND '$end' AND visit_userId = ".$user['user_id'])->row_array();
  
    $sap= $this->db->query("SELECT SUM(order_value) AS value, COUNT(order_id) AS total FROM tbl_orders JOIN tbl_distributors ON distributor_accountName = order_clientAcct WHERE order_cancelled = 0 AND STR_TO_DATE(order_date,'%d/%m/%Y') BETWEEN '$start' AND '$end' AND order_from = 'SAP' AND order_status > 0 AND salesEmpNo = ".$user['user_sapId'])->row_array();
      
    $pmts = $this->db->query("SELECT SUM(payment_amount) AS total FROM tbl_payments JOIN tbl_visits ON visit_id = payment_visitId WHERE DATE(payment_date) BETWEEN '$start' AND '$end' AND visit_userId = ".$user['user_id'])->row_array();
    
    $blocks = get_data('tbl_blocks', "WHERE block_active = 1 AND block_id = ".$user['user_fieldId']);
    
    
} elseif($user['user_usertypeid'] == 2) {
    $csfa = $this->db->query("SELECT SUM(order_value) AS value, SUM(od_skuQty) AS volume, COUNT(order_id) AS total FROM tbl_orderdetails JOIN tbl_orders ON od_orderid = order_id JOIN tbl_visits ON visit_id = order_visitId JOIN tbl_users ON user_id = visit_userId WHERE order_cancelled = 0 AND STR_TO_DATE(order_date,'%Y-%m-%d') BETWEEN '$start' AND '$end' AND user_fieldId = ".$user['user_fieldId'])->row_array();
  
    $sap= $this->db->query("SELECT SUM(order_value) AS value, COUNT(order_id) AS total FROM tbl_orders JOIN tbl_distributors ON distributor_accountName = order_clientAcct WHERE order_cancelled = 0 AND STR_TO_DATE(order_date,'%d/%m/%Y') BETWEEN '$start' AND '$end' AND order_from = 'SAP' AND order_status > 0 AND distributor_blockId = ".$user['user_fieldId'])->row_array();
      
    $pmts = $this->db->query("SELECT SUM(payment_amount) AS total FROM tbl_payments JOIN tbl_visits ON visit_id = payment_visitId JOIN tbl_users ON user_id = visit_userId WHERE DATE(payment_date) BETWEEN '$start' AND '$end' AND user_fieldId = ".$user['user_fieldId'])->row_array();
    
    $blocks = get_data('tbl_blocks', "WHERE block_active = 1 AND block_id = ".$user['user_fieldId']);
    
    
} else {
    $csfa = $this->db->query("SELECT SUM(order_value) AS value, SUM(od_skuQty) AS volume, COUNT(order_id) AS total FROM tbl_orderdetails JOIN tbl_orders ON od_orderid = order_id WHERE order_cancelled = 0 AND STR_TO_DATE(order_date,'%d/%m/%Y') BETWEEN '$start' AND '$end'")->row_array();
  
    $sap= $this->db->query("SELECT SUM(order_value) AS value, COUNT(order_id) AS total FROM tbl_orders WHERE order_cancelled = 0 AND STR_TO_DATE(order_date,'%d/%m/%Y') BETWEEN '$start' AND '$end' AND order_from = 'SAP'")->row_array();
      
    $pmts = $this->db->query("SELECT SUM(payment_amount) AS total FROM tbl_payments WHERE DATE(payment_date) BETWEEN '$start' AND '$end'")->row_array();
    
    $blocks = get_data('tbl_blocks', "WHERE block_active = 1");
}
  
function get_sapVolume()
{
    global $user;
    $start = date('01/m/Y'); $end = date('d/m/Y');
    $conn = mssql_connect('192.168.21.95', 'so', 'Csfa@14') or die("Error connecting to mssql server");
    $field = $user['user_fieldId'];
  
    if($user['user_usertypeid'] == 3) {
        $sql = "select SUM(Quantity*SVolume) AS totals, Item_Code FROM MIP_T_CSFA_SODetail
    INNER JOIN MIP_T_CSFA_SOHeader ON  MIP_T_CSFA_SODetail.Order_Id =  MIP_T_CSFA_SOHeader.Order_Id
    JOIN OCRD1 ON Card_Code = CardCode
    WHERE MIP_T_CSFA_SODetail.Delivery_Date BETWEEN
     DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()), 0)
     AND
     DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()) + 1, 0) AND Territory = $field GROUP BY Item_Code;";
    }
    
    elseif($user['user_usertypeid'] == 2) {
        
        $sql = "select SUM(Quantity*SVolume) AS totals, Item_Code FROM MIP_T_CSFA_SODetail
    INNER JOIN MIP_T_CSFA_SOHeader ON  MIP_T_CSFA_SODetail.Order_Id =  MIP_T_CSFA_SOHeader.Order_Id
    JOIN OCRD1 ON Card_Code = CardCode
    WHERE MIP_T_CSFA_SODetail.Delivery_Date BETWEEN
     DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()), 0)
     AND
     DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()) + 1, 0) AND Territory = $field GROUP BY Item_Code;";
    }
    
    else {
        $sql = "select SUM(Quantity*SVolume) AS totals, Item_Code FROM MIP_T_CSFA_SODetail
    INNER JOIN MIP_T_CSFA_SOHeader ON  MIP_T_CSFA_SODetail.Order_Id =  MIP_T_CSFA_SOHeader.Order_Id
    JOIN OCRD1 ON Card_Code = CardCode
    WHERE MIP_T_CSFA_SODetail.Delivery_Date BETWEEN
     DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()), 0)
     AND
     DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()) + 1, 0) GROUP BY Item_Code;";
    }
    $query = mssql_query($sql);
    $qty = 0;
    if($query) {
     while($row = mssql_fetch_array($query))
            $qty += $row['totals'];
    }
    
    return $qty;
}
function get_collections()
{
    $amt = 0;
    foreach(get_data('tbl_payments') as $p) {
        $amt += $p['payment_amount'];
    }
    return $amt;
}

function get_order_value()
{
    $amt = 0;
  $start = date('Y-m-01'); $end = date('Y-m-d');
    foreach(get_data('tbl_orders', "WHERE order_cancelled = 0 AND STR_TO_DATE(order_date,'%Y-%m-%d') BETWEEN '$start' AND '$end'") as $o) {
        $amt += $o['order_value'];
    }
    return $amt;
}

function get_orders()
{
  $start = date('Y-m-01'); $end = date('Y-m-d');
    return count(get_data('tbl_orders', "WHERE order_cancelled = 0 AND DATE(order_date) BETWEEN '$start' AND '$end'"));
}

function get_visits()
{
    global $user;
    $start = date('Y-m-01'); $end = date('Y-m-d');
    $A =& get_instance();
    
    if($user['user_usertypeid'] == 3) {
        $visits = $A->db->query("SELECT COUNT(visit_id) AS visits FROM tbl_visits WHERE DATE(visit_date) BETWEEN '$start' AND '$end' AND visit_userId = ".$user['user_id'])->row_array();
    }elseif($user['user_usertypeid'] == 2) {
        $visits = $A->db->query("SELECT COUNT(visit_id) AS visits FROM tbl_visits JOIN tbl_users ON user_id = visit_userId WHERE DATE(visit_date) BETWEEN '$start' AND '$end' AND user_fieldId = ".$user['user_fieldId'])->row_array();
    }else{
        return count(get_data('tbl_visits', "WHERE DATE(visit_date) BETWEEN '$start' AND '$end'"));
    }
    
    return $visits;
}

function get_sales($compare=false)
{
    global $user;
    $A =& get_instance();
    if($compare) {
        $start = date('Y-m-01', strtotime('-1 month')); $end = date('Y-m-d', strtotime('-1 month'));
    } else {
        $start = date('Y-m-01'); $end = date('Y-m-d');
    }
    if($user['user_usertypeid'] == 3) {
        $orders = $A->db->query("SELECT SUM(order_value) AS total_value FROM tbl_orders JOIN tbl_distributors ON distributor_accountName = order_clientAct WHERE order_cancelled = 0 AND order_status = 1 AND STR_TO_DATE(order_date,'%d/%m/%Y') BETWEEN '$start' AND '$end' AND salesEmpNo = ".$user['user_sapId'])->row_array();
    } elseif($user['user_usertypeid'] == 2) {
        $orders = $A->db->query("SELECT SUM(order_value) AS total_value FROM tbl_orders JOIN tbl_distributors ON distributor_accountName = order_clientAct WHERE order_cancelled = 0 AND order_status = 1 AND STR_TO_DATE(order_date,'%d/%m/%Y') BETWEEN '$start' AND '$end' AND distributor_blockId = ".$user['user_fieldId'])->row_array();
    } else {
        $orders = $A->db->query("SELECT SUM(order_value) AS total_value FROM tbl_orders WHERE order_cancelled = 0 AND order_status = 1 AND STR_TO_DATE(order_date,'%d/%m/%Y') BETWEEN '$start' AND '$end'")->row_array();
    }
    return $orders['total_value'];
}



function block_comparison($block, $compare=false)
{
    $bs = get_blockSales($block, $compare); $sales = get_sales($compare);
    return $sales > 0 ? $bs/$sales * 100 : 0;
    
}

function visit_compare($block, $tm=true)
{
    global $user;
    if($tm) {
        $start = date('Y-m-01'); $end = date('Y-m-d');
    } else {
        $start = date('Y-m-01', strtotime('-1 month')); $end = date('Y-m-d', strtotime('-1 month'));
    }
    $A =& get_instance();
    
    if($user['user_usertypeid'] == 3) {
        $visit = $A->db->query("SELECT COUNT(visit_id) AS visits FROM tbl_visits WHERE DATE(visit_date) BETWEEN '$start' AND '$end' AND visit_userId = ".$user['user_id'])->row_array();
        $visits = $visit['visits'];
    }elseif($user['user_usertypeid'] == 2) {
        $visit = $A->db->query("SELECT COUNT(visit_id) AS visits FROM tbl_visits JOIN tbl_users ON user_id = visit_userId WHERE DATE(visit_date) BETWEEN '$start' AND '$end' AND user_fieldId = ".$user['user_fieldId'])->row_array();
        $visits = $visit['visits'];
    }else{
        return count(get_data('tbl_visits', "JOIN tbl_users ON user_id = visit_userId WHERE user_fieldId = $block AND DATE(visit_date) BETWEEN '$start' AND '$end'"));
    }
    
    return $visits;
}

?>


      <!-- page content -->
      <div class="right_col" role="main">

        <!-- top tiles-->
        <div class="row tile_count">
          <div class="animated flipInY col-md-3 col-sm-4 col-xs-4 tile_stats_count">
            <div class="left"></div>
            <div class="right">
              <span class="count_top"><i class="fa fa-connectdevelop"></i> Total Collections</span>
              <div class="count"><a href="<?php echo site_url('welcome/view/collections')?>"><?php echo custom_number_format($pmts['total']);?></a></div>
              <!--<span class="count_bottom"><i class="green">8% </i> From last month</span>-->
            </div>
          </div>
          
          <div class="animated flipInY col-md-3 col-sm-4 col-xs-4 tile_stats_count">
            <div class="left"></div>
            <div class="right">
              <span class="count_top"><i class="fa fa-user"></i> Total Orders</span>
              <div class="count green"><a href="<?php echo site_url('welcome/view/orders')?>" id="vol-label"><?php echo $orders['o_total'];?></a></div>
              <!--<span class="count_bottom"><i class="green"><i class="fa fa-sort-asc"></i>2% </i> From last month</span>-->
            </div>
          </div>
          <div class="animated flipInY col-md-3 col-sm-4 col-xs-4 tile_stats_count">
            <div class="left"></div>
            <div class="right">
              <span class="count_top"><i class="fa fa-user"></i> Order Value</span>
              <div class="count"><a href="<?php echo site_url('welcome/view/orders')?>"><?php echo custom_number_format($sap['value']);?></a></div>
              <!--<span class="count_bottom"><i class="red"><i class="fa fa-sort-desc"></i>2% </i> From last month</span>-->
            </div>
          </div>
          <div class="animated flipInY col-md-3 col-sm-4 col-xs-4 tile_stats_count">
            <div class="left"></div>
            <div class="right">
              <span class="count_top"><i class="fa fa-user"></i> Total Visits</span>
              <div class="count"><a href="<?php echo site_url('welcome/view/visits');?>"><?php echo number_format(get_visits());?></a></div>
              <!--<span class="count_bottom"><i class="green"><i class="fa fa-sort-asc"></i>13% </i> From last month</span>-->
            </div>
          </div>
          

        </div>
        <!-- /top tiles -->

        <div class="row">
          <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="dashboard_graph">

              <div class="row x_title">
                <div class="col-md-6">
                  <h3><small>Dealer Visits per Region</small></h3>
                </div>
                <div class="col-md-6">
                  <!--<div id="reportrange" class="pull-right" style="background: #fff; cursor: pointer; padding: 5px 10px; border: 1px solid #ccc">
                    <i class="glyphicon glyphicon-calendar fa fa-calendar"></i>
                    <span>December 30, 2014 - January 28, 2015</span> <b class="caret"></b>
                  </div>-->
                </div>
              </div>

              <div class="col-md-8 col-sm-9 col-xs-12">
                <div id="placeholder33" style="height: 260px; display: none" class="demo-placeholder"></div>
                <div style="width: 100%;">
                  <div id="echart_pie" style="height:450px;"></div>
                  
                </div>
              </div>
              <div class="col-md-4 col-sm-3 col-xs-12 bg-white">
                <div class="x_title">
                  <p>Last Month (LM) vs This Month (CM) Comparison <br /><small>By Visits</small></p>
                  <div class="clearfix"></div>
                </div>

                <div class="col-md-12 col-sm-12 col-xs-6">
                  <table class="table table-bordered table-hover">
                    <thead>
                      <th>Region</th> <th>This Month</th> <th> Last Month</th>
                   </thead>
                   <tbody>
                     <?php foreach($blocks as $blc) { ?>
                     <tr>
                       <td><?php echo $blc['block_name'];?></td>
                       <td><?php echo visit_compare($blc['block_id']);?></td>
                       <td><?php echo visit_compare($blc['block_id'], false);?></td>
                     </tr>
                     <?php } ?>
                   </tbody>
                  </table>
                  
                </div>

              </div>

              <div class="clearfix"></div>
            </div>
          </div>

        </div>
        <br />

        <div class="row">


          <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="x_panel tile" style="overflow-y: auto;">
              <div class="x_title">
                <h2>Sales Officers <small>By Dealer Visits</small></h2>
                <ul class="nav navbar-right panel_toolbox">
                  <li><a class="collapse-link"><i class="fa fa-chevron-up"></i></a>
                  </li>
                  <li class="dropdown">
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false"><i class="fa fa-list"></i></a>
                    <ul class="dropdown-menu" role="menu">
                      <?php foreach($blocks as $blk) { ?>
                      <li><a href="javascript: change_tb(<?php echo $blk['block_id'];?>)"><?php echo $blk['block_name'];?></a>
                      </li>
                      <?php } ?>
                      <li><a href="javascript: change_tb(0)">All</a>
                      </li>
                    </ul>
                  </li>
                  <li><a class="close-link"><i class="fa fa-close"></i></a>
                  </li>
                </ul>
                <div class="clearfix"></div>
              </div>

              <div class="x_content"> 
                  <div id="top-dealers"></div>
                  


              </div>
            </div>
          </div>

          <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="x_panel tile" style="overflow-y: auto;">
              <div class="x_title">
                <h2>Visits Types <small>By Count</small></h2>
                <ul class="nav navbar-right panel_toolbox">
                  <li><a class="collapse-link"><i class="fa fa-chevron-up"></i></a>
                  </li>
                  <li class="dropdown">
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false"><i class="fa fa-list"></i></a>
                    <ul class="dropdown-menu" role="menu">
                      <?php foreach($blocks as $blk) { ?>
                      <li><a href="javascript: change_tp(<?php echo $blk['block_id'];?>)"><?php echo $blk['block_name'];?></a>
                      </li>
                      <?php } ?>
                      <li><a href="javascript: change_tp(0)">All</a>
                      </li>
                    </ul>
                  </li>
                  <li><a class="close-link"><i class="fa fa-close"></i></a>
                  </li>
                </ul>
                <div class="clearfix"></div>
              </div>
              <div class="x_content">

                <div id="top-products" class="row"></div>
              </div>
            </div>
          </div>

        </div>

<?php $this->load->view('layout/footer'); ?>
    
    <!-- gauge js -->
  <script type="text/javascript" src="<?php echo base_url('assets/js/gauge/gauge.min.js')?>"></script>
  <script type="text/javascript" src="<?php echo base_url('assets/js/gauge/gauge_demo.js')?>"></script>
  
  <script type="text/javascript" src="<?php echo base_url('assets/js/datepicker/daterangepicker.js')?>"></script>
  <!-- chart js -->
  <script src="<?php echo base_url('assets/js/chartjs/chart.min.js')?>"></script>

  <!-- flot js -->
  <!--[if lte IE 8]><script type="text/javascript" src="js/excanvas.min.js"></script><![endif]-->
  <script type="text/javascript" src="<?php echo base_url('assets/js/flot/jquery.flot.js')?>"></script>
  <script type="text/javascript" src="<?php echo base_url('assets/js/flot/jquery.flot.pie.js')?>"></script>
  <script type="text/javascript" src="<?php echo base_url('assets/js/flot/jquery.flot.orderBars.js')?>"></script>
  <script type="text/javascript" src="<?php echo base_url('assets/js/flot/jquery.flot.time.min.js')?>"></script>
  <script type="text/javascript" src="<?php echo base_url('assets/js/flot/date.js')?>"></script>
  <script type="text/javascript" src="<?php echo base_url('assets/js/flot/jquery.flot.spline.js')?>"></script>
  <script type="text/javascript" src="<?php echo base_url('assets/js/flot/jquery.flot.stack.js')?>"></script>
  <script type="text/javascript" src="<?php echo base_url('assets/js/flot/curvedLines.js')?>"></script>
  <script type="text/javascript" src="<?php echo base_url('assets/js/flot/jquery.flot.resize.js')?>"></script>
  <script>
    $(document).ready(function() {
      $('#top-dealers').load('<?php echo site_url('welcome/modal/top_officer')?>');
      $('#top-products').load('<?php echo site_url('welcome/modal/visit_types/0')?>');
      // [17, 74, 6, 39, 20, 85, 7]
      //[82, 23, 66, 9, 99, 6, 2]
      var data1 = [
        [gd(2012, 1, 1), 17],
        [gd(2012, 2, 1), 74],
        [gd(2012, 3, 1), 6],
        [gd(2012, 4, 1), 39],
        [gd(2012, 5, 1), 20],
        [gd(2012, 6, 1), 85],
        [gd(2012, 7, 1), 7]
      ];

      
      $("#canvas_dahs").length && $.plot($("#canvas_dahs"), [
        data1
      ], {
        series: {
          lines: {
            show: false,
            fill: true
          },
          splines: {
            show: true,
            tension: 0.4,
            lineWidth: 1,
            fill: 0.4
          },
          points: {
            radius: 0,
            show: true
          },
          shadowSize: 2
        },
        grid: {
          verticalLines: true,
          hoverable: true,
          clickable: true,
          tickColor: "#d5d5d5",
          borderWidth: 1,
          color: '#fff'
        },
        colors: ["rgba(38, 185, 154, 0.38)", "rgba(3, 88, 106, 0.38)"],
        xaxis: {
          tickColor: "rgba(51, 51, 51, 0.06)",
          mode: "time",
          tickSize: [1, "month"],
          //tickLength: 10,
          axisLabel: "Date",
          axisLabelUseCanvas: true,
          axisLabelFontSizePixels: 12,
          axisLabelFontFamily: 'Verdana, Arial',
          axisLabelPadding: 10
            //mode: "time", timeformat: "%m/%d/%y", minTickSize: [1, "day"]
        },
        yaxis: {
          ticks: 8,
          tickColor: "rgba(51, 51, 51, 0.06)",
        },
        tooltip: false
      });

      function gd(year, month, day) {
        return new Date(year, month - 1, day).getTime();
      }
    });
  </script>

  <!-- worldmap -->
  <script type="text/javascript" src="<?php echo base_url('assets/js/maps/jquery-jvectormap-2.0.3.min.js')?>"></script>
  <script type="text/javascript" src="<?php echo base_url('assets/js/maps/gdp-data.js')?>"></script>
  <script type="text/javascript" src="<?php echo base_url('assets/js/maps/jquery-jvectormap-world-mill-en.js')?>"></script>
  <script type="text/javascript" src="<?php echo base_url('assets/js/maps/jquery-jvectormap-us-aea-en.js')?>"></script>
  <!-- pace -->
  <script src="<?php echo base_url('assets/js/pace/pace.min.js')?>"></script>
  <script>
    $(function() {
      $('#world-map-gdp').vectorMap({
        map: 'world_mill_en',
        backgroundColor: 'transparent',
        zoomOnScroll: false,
        series: {
          regions: [{
            values: gdpData,
            scale: ['#E6F2F0', '#149B7E'],
            normalizeFunction: 'polynomial'
          }]
        },
        onRegionTipShow: function(e, el, code) {
          el.html(el.html() + ' (GDP - ' + gdpData[code] + ')');
        }
      });
    });
  </script>
  <!-- skycons -->
  <script src="<?php echo base_url('assets/js/skycons/skycons.min.js')?>"></script>
  <script>
    var icons = new Skycons({
        "color": "#73879C"
      }),
      list = [
        "clear-day", "clear-night", "partly-cloudy-day",
        "partly-cloudy-night", "cloudy", "rain", "sleet", "snow", "wind",
        "fog"
      ],
      i;

    for (i = list.length; i--;)
      icons.set(list[i], list[i]);

    icons.play();
  </script>

  <!-- dashbord linegraph -->
  <script>
    Chart.defaults.global.legend = {
      enabled: false
    };
    
    var canvasDoughnut1 = new Chart(document.getElementById("canvas2"), {
      type: 'doughnut',
      tooltipFillColor: "rgba(51, 51, 51, 0.55)",
      data: {
        labels: [
            <?php echo rtrim($p_chart['labels'],',')?>
          ],
          datasets: [{
            data: [<?php echo rtrim($p_chart['datasets'],',')?>],
            backgroundColor: [
              '#515d5a','#d4ac0d','#ff93ac','#17a589','##fbeee6','#2980b9','#8e9a87','#d7bde2','#8d8d93','#c0392b'
            ],
            hoverBackgroundColor: [
              '#515d5a','#444d49','#ff93ac','#b0e0e6','#9ca089','#9c9c9c','#8e9a87','#8d92a3','#8d8d93','#8b8f9a'],
    
          }]
      }
    });
  </script>
  <!-- /dashbord linegraph -->
  
  <!-- echart -->
  <script src="<?php echo base_url('assets/js/echart/echarts-all.js')?>"></script>
  <script src="<?php echo base_url('assets/js/echart/green.js')?>"></script>
  <script>
    $.get('<?php echo site_url('data/get_block_chart_data')?>', function(res) {
      var d = JSON.parse(res);
     //console.log(res);
    var myChart = echarts.init(document.getElementById('echart_pie'), theme);
    myChart.setOption({
      title : {
        text: 'Regional Performance',
        subtext: 'By No of Visits',
        x:'center'
    },tooltip: {
        trigger: 'item',
        formatter: "{b} <br/> {c} ({d}%)"
      },
      /*legend: {
        orient: 'vertical',
        x: 'left',
        x: 'center',
        y: 'bottom',
        data: [<?php echo rtrim($block_chart['labels'],',')?>]
      },*/
      toolbox: {
        show: false,
        feature: {
          magicType: {
            show: true,
            type: ['pie', 'funnel'],
            option: {
              funnel: {
                x: '25%',
                width: '50%',
                funnelAlign: 'left',
                max: 1548
              }
            }
          },
          restore: {
            show: true
          },
          saveAsImage: {
            show: true
          }
        }
      },
      calculable: true,
      series: [{
        name: 'Regional Performance',
        type: 'pie',
        radius: '55%',
        center: ['50%', '48%'], //left,top
        data: d.datasets
      }]
    });  
    });
 </script>
  <!-- datepicker -->
  <script type="text/javascript">
    $(document).ready(function() {
      
      var cb = function(start, end, label) {
        console.log(start.toISOString(), end.toISOString(), label);
        $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
        //alert("Callback has fired: [" + start.format('MMMM D, YYYY') + " to " + end.format('MMMM D, YYYY') + ", label = " + label + "]");
      }

      var optionSet1 = {
        startDate: moment().subtract(29, 'days'),
        endDate: moment(),
        minDate: '01/01/2012',
        maxDate: '12/31/2015',
        dateLimit: {
          days: 60
        },
        showDropdowns: true,
        showWeekNumbers: true,
        timePicker: false,
        timePickerIncrement: 1,
        timePicker12Hour: true,
        ranges: {
          'Today': [moment(), moment()],
          'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
          'Last 7 Days': [moment().subtract(6, 'days'), moment()],
          'Last 30 Days': [moment().subtract(29, 'days'), moment()],
          'This Month': [moment().startOf('month'), moment().endOf('month')],
          'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        },
        opens: 'left',
        buttonClasses: ['btn btn-default'],
        applyClass: 'btn-small btn-primary',
        cancelClass: 'btn-small',
        format: 'MM/DD/YYYY',
        separator: ' to ',
        locale: {
          applyLabel: 'Submit',
          cancelLabel: 'Clear',
          fromLabel: 'From',
          toLabel: 'To',
          customRangeLabel: 'Custom',
          daysOfWeek: ['Su', 'Mo', 'Tu', 'We', 'Th', 'Fr', 'Sa'],
          monthNames: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'],
          firstDay: 1
        }
      };
      $('#reportrange span').html(moment().subtract(29, 'days').format('MMMM D, YYYY') + ' - ' + moment().format('MMMM D, YYYY'));
      $('#reportrange').daterangepicker(optionSet1, cb);
      $('#reportrange').on('show.daterangepicker', function() {
        console.log("show event fired");
      });
      $('#reportrange').on('hide.daterangepicker', function() {
        console.log("hide event fired");
      });
      $('#reportrange').on('apply.daterangepicker', function(ev, picker) {
        console.log("apply event fired, start/end dates are " + picker.startDate.format('MMMM D, YYYY') + " to " + picker.endDate.format('MMMM D, YYYY'));
      });
      $('#reportrange').on('cancel.daterangepicker', function(ev, picker) {
        console.log("cancel event fired");
      });
      $('#options1').click(function() {
        $('#reportrange').data('daterangepicker').setOptions(optionSet1, cb);
      });
      $('#options2').click(function() {
        $('#reportrange').data('daterangepicker').setOptions(optionSet2, cb);
      });
      $('#destroy').click(function() {
        $('#reportrange').data('daterangepicker').remove();
      });
    });
  </script>
  <script>
    NProgress.done();
  </script>
  <!-- /datepicker -->
  <script>
    
    function change_tb(id) {
      $('#top-dealers').load('<?php echo site_url('welcome/modal/top_officer')?>/'+id);
    }
    
    function change_tp(id) {
      //console.log(id);
      $('#top-products').load('<?php echo site_url('welcome/modal/visit_types')?>/'+id);
    }
  </script>
  <!-- /footer content -->
</body>

</html>
