<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Company_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
    }
    
    public function create_route()
    {
        if(empty($_POST)) {
            return array('status' => 0, 'msg' => 'Sorry! We did not receive anything!!');
        }
        
        $data = array(
                    'route_date' => $this->input->post('date'),
                    'route_name' => $this->input->post('route'),
          'route_day' => $this->input->post('day'),
          'route_dealers' => implode(',', $this->input->post('dealers')),
                    'route_creator' => $this->session->userdata('user_id'),
                    'route_createdate' => date('Y-m-d H:i:s')
                );
        if($this->db->insert('tbl_routes', $data)) return array('status' => 1, 'msg' => 'Route created successfully!');
        
        else return array('status' => 0, 'msg' => 'Error! Route couldnot be created! Please try again later!');
    }
  
    public function update_route()
    {
        if(empty($_POST)) {
            return array('status' => 0, 'msg' => 'Sorry! We did not receive anything!!');
        }
        $route = $this->input->post('route_id');
        $data = array(
                    'route_date' => $this->input->post('date'),
                    'route_name' => $this->input->post('route'),
          'route_day' => $this->input->post('day'),
          'route_dealers' => implode(',', $this->input->post('dealers')),
                    //'route_creator' => $this->session->userdata('user_id'),
                    //'route_createdate' => date('Y-m-d H:i:s')
                );
        if($this->db->update('tbl_routes', $data, array('route_id' => $route))) return array('status' => 1, 'msg' => 'Route updated successfully!');
        
        else return array('status' => 0, 'msg' => 'Error! Route couldnot be updated! Please try again later!');
    }
  
    public function delete_route()
    {
        if(empty($_POST)) {
            return array('status' => 0, 'msg' => 'Sorry! We did not receive anything!!');
        }
        $route = $this->input->post('route_id');
        if($this->db->delete('tbl_routes', array('route_id' => $route))) return array('status' => 1, 'msg' => 'Route deleted successfully!');
        
        else return array('status' => 0, 'msg' => 'Error! Route couldnot be deleted! Please try again later!');
    }
    
    public function update_scheme()
    {
        if(empty($_POST)) {
            return array('status' => 0, 'msg' => 'Sorry! We did not receive anything!!');
        }
        
        $data = array(
                    'scheme_description' => $this->input->post('desc'),
                    'scheme_name' => $scheme,
                    'scheme_updator' => $this->session->userdata('user_id')
                );
        if($this->db->update('tbl_schemes', $data, array('scheme_id' => $this->input->post('scheme_id')))) return array('status' => 1, 'msg' => 'Scheme updated successfully!');
        
        else return array('status' => 0, 'msg' => 'Error! Scheme couldnot be updated! Please try again later!');
    }
    
    public function create_routes()
    {
        if(empty($_POST)) {
            return array('status' => 0, 'msg' => 'Sorry! We did not receive anything!!');
        }
        
        $route = $this->input->post('route_code');
        $row = get_row_data('tbl_routes', 'route_code', $route);
        
        if(!empty($row)) return array('status' => 0, 'msg' => 'Route already exists. Please choose another one!');
        
        $data = array(
                    'route_description' => $this->input->post('desc'),
                    'route_code' => $route,
                    'route_name' => $this->input->post('route_name'),
                    'route_schemeid' => $this->input->post('scheme'),
                    'route_creator' => $this->session->userdata('user_id'),
                    'route_createdate' => date('Y-m-d H:i:s')
                );
        if($this->db->insert('tbl_routes', $data)) return array('status' => 1, 'msg' => 'Route created successfully!');
        
        else return array('status' => 0, 'msg' => 'Error! Route couldnot be created! Please try again later!');
    }
    
    public function update_routes()
    {
        if(empty($_POST)) {
            return array('status' => 0, 'msg' => 'Sorry! We did not receive anything!!');
        }
        
        $data = array(
                    'route_description' => $this->input->post('desc'),
                    'route_name' => $this->input->post('route_name'),
                    'route_schemeid' => $this->input->post('scheme'),
                    'route_updator' => $this->session->userdata('user_id')
                );
        if($this->db->update('tbl_routes', $data, array('route_id' => $this->input->post('route_id')))) return array('status' => 1, 'msg' => 'Route updated successfully!');
        
        else return array('status' => 0, 'msg' => 'Error! Route couldnot be updated! Please try again later!');
    }
    
    public function create_consumer()
    {
        if(empty($_POST)) {
            return array('status' => 0, 'msg' => 'Sorry! We did not receive anything!!');
        }
        
        $number = $this->input->post('consumer');
        $row = get_row_data('tbl_consumers', 'consumer_number', $number);
        
        if(!empty($row)) return array('status' => 0, 'msg' => 'Consumer Number already exists. Please choose another one!');
        
        $name = $this->input->post('full_name');
        $row = get_row_data('tbl_consumers', 'consumer_name', $name);
        
        if(!empty($row)) return array('status' => 0, 'msg' => 'Consumer Name already exists. Please choose another one!');
        
        $data = array(
                    'consumer_name' => $name,
                    'consumer_number' => $number,
                    'consumer_phone' => $this->input->post('phone'),
                    'consumer_ctid' => $this->input->post('type'),
                    'consumer_email' => $this->input->post('email'),
                    'consumer_address' => $this->input->post('address'),
                    'consumer_pin' => $this->input->post('pin'),
                    'consumer_creator' => $this->session->userdata('user_id'),
                    'consumer_createdate' => date('Y-m-d H:i:s')
                );
        if($this->db->insert('tbl_consumers', $data)) return array('status' => 1, 'msg' => 'Consumer created successfully!');
        
        else return array('status' => 0, 'msg' => 'Error! Consumer couldnot be created! Please try again later!');
    }
    
    public function update_consumer()
    {
        if(empty($_POST)) {
            return array('status' => 0, 'msg' => 'Sorry! We did not receive anything!!');
        }
                
        $data = array(
                    'consumer_name' => $this->input->post('full_name'),
                    'consumer_phone' => $this->input->post('phone'),
                    'consumer_ctid' => $this->input->post('type'),
                    'consumer_email' => $this->input->post('email'),
                    'consumer_address' => $this->input->post('address'),
                    'consumer_pin' => $this->input->post('pin'),
                    'consumer_updator' => $this->session->userdata('user_id')
                );
        if($this->db->update('tbl_consumers', $data, array('consumer_id' => $this->input->post('consumer_id')))) return array('status' => 1, 'msg' => 'Consumer updated successfully!');
        
        else return array('status' => 0, 'msg' => 'Error! Consumer couldnot be updated! Please try again later!');
    }
    
    public function create_ct()
    {
        if(empty($_POST)) {
            return array('status' => 0, 'msg' => 'Sorry! We did not receive anything!!');
        }
        
        $name = $this->input->post('ct_name');
        $row = get_row_data('tbl_consumertypes', 'ct_name', $name);
        
        if(!empty($row)) return array('status' => 0, 'msg' => 'Consumer Type already exists. Please choose another one!');
        
        $data = array(
                    'ct_name' => $name,
                    'ct_description' => $this->input->post('desc'),
                    'ct_creator' => $this->session->userdata('user_id'),
                    'ct_createdate' => date('Y-m-d H:i:s')
                );
        if($this->db->insert('tbl_consumertypes', $data)) return array('status' => 1, 'msg' => 'Consumer type created successfully!');
        
        else return array('status' => 0, 'msg' => 'Error! Consumer Type couldnot be created! Please try again later!');
    }
    
    public function update_ct()
    {
        if(empty($_POST)) {
            return array('status' => 0, 'msg' => 'Sorry! We did not receive anything!!');
        }
        
        $data = array(
                    'ct_name' => $name,
                    'ct_description' => $this->input->post('desc'),
                    'ct_updator' => $this->session->userdata('user_id')
                );
        if($this->db->update('tbl_consumertypes', $data, array('ct_id' => $this->input->post('ct_id')))) return array('status' => 1, 'msg' => 'Consumer type created successfully!');
        
        else return array('status' => 0, 'msg' => 'Error! Consumer Type couldnot be created! Please try again later!');
    }
    
    public function create_ctype()
    {
        if(empty($_POST)) {
            return array('status' => 0, 'msg' => 'Sorry! We did not receive anything!!');
        }
        
        $name = $this->input->post('ct_name');
        $row = get_row_data('tbl_connectiontypes', 'ctype_name', $name);
        
        if(!empty($row)) return array('status' => 0, 'msg' => 'Connection Type already exists. Please choose another one!');
        
        $data = array(
                    'ctype_name' => $name,
                    'ctype_description' => $this->input->post('desc'),
                    'ctype_creator' => $this->session->userdata('user_id'),
                    'ctype_createdate' => date('Y-m-d H:i:s')
                );
        if($this->db->insert('tbl_connectiontypes', $data)) return array('status' => 1, 'msg' => 'Connection type created successfully!');
        
        else return array('status' => 0, 'msg' => 'Error! Connection Type couldnot be created! Please try again later!');
    }
    
    public function update_ctype()
    {
        if(empty($_POST)) {
            return array('status' => 0, 'msg' => 'Sorry! We did not receive anything!!');
        }
        
        $data = array(
                    'ctype_name' => $name,
                    'ctype_description' => $this->input->post('desc'),
                    'ctype_updator' => $this->session->userdata('user_id')
                );
        if($this->db->update('tbl_connectiontypes', $data, array('ctype_id' => $this->input->post('ct_id')))) return array('status' => 1, 'msg' => 'Consumer type created successfully!');
        
        else return array('status' => 0, 'msg' => 'Error! Consumer Type couldnot be created! Please try again later!');
    }
}