<?php

function get_data($table, $where = "")
{
    $CI =& get_instance();
    $query = $CI->db->query("SELECT * FROM $table $where");
    
    if(!$query) return array();
    
    return $query->result_array();
}

function get_row_data($table, $key, $value)
{
    $POS =& get_instance();
    
    $query = $POS->db->get_where($table, array($key => $value));
    
    if($query->num_rows() == 0) return array();
    
    return $query->row_array();
}

function get_that_data($table, $key, $value, $column)
{
    $result = get_row_data($table, $key, $value);
    
    if(!empty($result)) return $result["$column"];
    
    return '';        
}

function record_exists($table, $column, $value)
{
    $row = get_row_data($table, $column, $value);
    if(empty($row)) {
        return false;
    }
    
    return true;
}

function get_dist_csfa($did, $start, $end)
{
    $A =& get_instance();
    $csfa = $A->db->query("SELECT SUM(order_value) AS value, SUM(od_skuQty) AS volume, COUNT(order_id) AS total FROM tbl_orderdetails JOIN tbl_orders ON od_orderid = order_id JOIN tbl_visits ON visit_id = order_visitId WHERE visit_outlet_id = $did AND STR_TO_DATE(order_date,'%Y-%m-%d') BETWEEN '$start' AND '$end' AND order_from = 'CSFA' GROUP BY visit_outlet_id");
    return $csfa->row_array();
}

function get_dist_sap($acc, $start, $end)
{
    $A =& get_instance();
    $conn = mssql_connect('192.168.21.95', 'so', 'Csfa@14');
    //Check only for those that have had the status updated by SAP i.e. sap order id != null
      
    $data = $A->db->query("SELECT order_sapId, order_value FROM tbl_orders WHERE order_from = 'SAP' AND order_clientAcct = '$acc' AND STR_TO_DATE(order_date,'%d/%m/%Y') BETWEEN '$start' AND '$end'")->result_array();
    
    $value = $total = $volume = 0;
    foreach($data as $d) {
        $value += $d['order_value'];
        $total++;
        $sql = "select SUM(OrderDetails_Qty) AS order_volume from OrderDetailsView where OrderDetailsID = ".$d['order_sapId'];
        $query = mssql_query($sql);
        $row = mssql_fetch_array($query);
        $volume += $row['order_volume'];
    }
    
    return array('value' => $value, 'volume' => $volume, 'total' => $total);
}
  
function get_last_visit_date($dist)
{
  $A =& get_instance();
  $sql = $A->db->query("SELECT visit_updatedate FROM tbl_visits WHERE visit_outlet_id = $dist ORDER BY visit_date DESC LIMIT 1")->row_array();
  return isset($sql['visit_updatedate']) ? $sql['visit_updatedate'] : false;
}

function get_alert_summary($user_level)
{
    $A =& get_instance();
    $others = $A->db->query("SELECT COUNT(other_id) AS total FROM tbl_others WHERE other_id NOT IN (SELECT resp_reason_id FROM tbl_responses WHERE resp_reason = 'other')")->row_array();
    
    $branding = $A->db->query("SELECT COUNT(branding_id) AS total FROM tbl_branding WHERE branding_id NOT IN (SELECT resp_reason_id FROM tbl_responses WHERE resp_reason = 'branding')")->row_array();
    
    $marketing = $A->db->query("SELECT COUNT(marketing_id) AS total FROM tbl_marketing WHERE marketing_id NOT IN (SELECT resp_reason_id FROM tbl_responses WHERE resp_reason = 'marketing')")->row_array();
    
    $pc = $A->db->query("SELECT COUNT(pc_id) AS total FROM tbl_productcomplains WHERE pc_id NOT IN (SELECT resp_reason_id FROM tbl_responses WHERE resp_reason = 'pc')")->row_array();
    
    $training = $A->db->query("SELECT COUNT(training_id) AS total FROM tbl_trainings WHERE training_id NOT IN (SELECT resp_reason_id FROM tbl_responses WHERE resp_reason = 'training')")->row_array();
    
    $du = $A->db->query("SELECT COUNT(du_id) AS total FROM tbl_duissues WHERE du_id NOT IN (SELECT resp_reason_id FROM tbl_responses WHERE resp_reason = 'du')")->row_array();
    
    $ci = $A->db->query("SELECT COUNT(ci_id) AS total FROM tbl_compeinfo WHERE ci_id NOT IN (SELECT resp_reason_id FROM tbl_responses WHERE resp_reason = 'compe')")->row_array();
    
    return array('others' => $others['total'], 'branding' => $branding['total'], 'marketing' => $marketing['total'], 'pc' => $pc['total'], 'training' => $training['total'], 'du' => $du['total'], 'ci' => $ci['total']);
}
  
function get_blockSales($block, $compare=false)
{
    $A =& get_instance();
    if(!$compare) {
        $start = date('Y-m-01'); $end = date('Y-m-d');
        $orders = $A->db->query("SELECT SUM(order_value) AS total_value FROM tbl_orders JOIN tbl_distributors ON distributor_accountName = order_clientAcct WHERE distributor_blockid = $block AND order_cancelled = 0 AND STR_TO_DATE(order_date,'%d/%m/%Y') BETWEEN '$start' AND '$end'")->row_array();
        return is_null($orders['total_value']) ? 0 : $orders['total_value'];
    } else {
        
        $start = date('Y-m-01', strtotime('-1 month')); $end = date('Y-m-d', strtotime('-1 month'));
        $last = $A->db->query("SELECT SUM(order_value) AS last_value FROM tbl_orders JOIN tbl_distributors ON distributor_accountName = order_clientAcct WHERE distributor_blockid = $block AND order_cancelled = 0 AND STR_TO_DATE(order_date,'%d/%m/%Y') BETWEEN '$start' AND '$end'")->row_array();
        
        return $last['last_value'];
    }
}
  
function issue_status($tbl, $type, $id, $key)
{
  $A =& get_instance();
  $query = $A->db->query("SELECT * FROM $tbl WHERE $key IN (SELECT resp_reason_id FROM tbl_responses WHERE resp_reason = '$type') AND $key = $id");
  if($query->num_rows() == 0) return 0;
  else return 1;
}
  
function custom_number_format($n, $precision = 3) {
    if ($n < 1000) {
        // Anything less than a thoudand
        $n_format = number_format($n);
    } else if ($n < 1000000) {
        // Anything less than a million
        $n_format = number_format($n / 1000, $precision) . 'K';
    } else {
        // At least a million
        $n_format = number_format($n / 1000000, $precision) . 'M';
    }

    return $n_format;
}
  
function sendMail($to, $subject, $message, $files=array())
    { 
      require_once('mail/PHPMailerAutoload.php');

        $mail = new PHPMailer;


        $mail->SMTPDebug = 3;                               // Enable verbose debug output

        $mail->isSMTP();                                      // Set mailer to use SMTP
        $mail->Host = 'smtp.office365.com';  // Specify main and backup SMTP servers
        $mail->SMTPAuth = true;                               // Enable SMTP authentication
        $mail->Username = 'salesnet@crownpaints.co.ke';                 // SMTP username
        $mail->Password = 'Crown123';                           // SMTP password
//$mail->SMTPSecure = 'ssl';                            // Enable TLS encryption, `ssl` also accepted
        $mail->Port = 587;                                    // TCP port to connect to

        $mail->setFrom('salesnet@crownpaints.co.ke', 'Crown SalesNet');

        //Test addresses
        //$mail->addAddress('ayiembaeb@mgail.com');
        $mail->addAddress('joshua.ogutu@crownpaints.co.ke');


        if (is_array($to)) {
            foreach ($to as $email)
                $mail->addAddress($email);     // Add a recipient
        } else {
            $mail->addAddress($to);     // Add a recipient
        }

        if (sizeof($files) > 0) {

            foreach ($files as $image) {

                $image = str_replace("{", "", $image);
                $image = str_replace("}", "", $image);
                $mail->addAttachment($image);
            }


        }        // Add attachments
        $mail->isHTML(true);                                  // Set email format to HTML

        $mail->Subject = $subject;
        $mail->Body = $message;

        return $mail->send();


    }

