<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Welcome extends CI_Controller {

  /**
   * Index Page for this controller.
   *
   * Maps to the following URL
   *     http://example.com/index.php/welcome
   *  - or -  
   *     http://example.com/index.php/welcome/index
   *  - or -
   * Since this controller is set as the default controller in 
   * config/routes.php, it's displayed at http://example.com/
   *
   * So any other public methods not prefixed with an underscore will
   * map to /index.php/welcome/<method_name>
   * @see http://codeigniter.com/user_guide/general/urls.html
   */
  public function index()
  {
    if($this->session->userdata('user_id')) {
      $this->load->view('home');
    } else {
      $this->load->view('login');
    }
  }
    
    public function login()
    {
        $this->load->model('users_model');
        $result = $this->users_model->login();
        if($result['status'] == 1) {
            redirect();
        } else {
            $data['error'] = $result['msg'];
            $this->load->view('login', $data);
        }
    }
    
    public function view($page, $param='')
    {
        if(!$this->session->userdata('user_id')) $this->load->view('login');
        else $this->load->view('pages/'.$page, array('param' => $param));
    }
  
  public function reports($page, $param='')
    {
        if(!$this->session->userdata('user_id')) $this->load->view('login');
        else $this->load->view('reports/'.$page, array('param' => $param));
    }
    
    public function modal($modal, $param='')
    {
        $data['param'] = $param;
        $this->load->view('modals/'.$modal, $data);
    }
  
  public function test_mail()
  {
    sendMail("alfkorir11@gmail.com", "Testing SN Mail", "Hey there. Test");
  }
}
  

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */